#version 130
#extension GL_EXT_gpu_shader4 : enable
/////////////////////////////////////////////////////////////
// VGHD Wrapper for Shadertoy conversions by @Calgon


uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels




#define iTime u_Elapsed*1
#define iResolution u_WindowSize
//#define iGlobalTime u_Elapsed
#define iGlobalTime u_Elapsed


// Seems the word texture is important and should not be replaced.  Therefore we must replace
// Shadertoy iChannel0..3 with texture 0..3 further down
uniform sampler2D texture0; //Font
uniform sampler2D texture1; //Surfaces
uniform sampler2D texture2; //SurfacesB
uniform sampler2D texture3; //Random Greys

//vec4 texture1D_Fract(sampler2D sampler,vec2 P) {return texture(sampler,fract(P));}
//vec4 texture1D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture(sampler,fract(P),Bias);}
vec4 texture1D_Fract(sampler2D sampler,vec2 P) {return texture(sampler,fract(P));}
vec4 texture1D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture(sampler,fract(P),Bias);}

// Calgon Amemned texture1D to texture - wait and see if this will be an issue during conversions

//#define texture1D texture1D_Fract
#define texture texture1D_Fract



vec4 vTexCoord = gl_TexCoord[0];


//#define iMouse vec4(0.0)

// Alternative Macro if iMouse is better moving
 #define iMouse AUTO_MOUSE  //vec4(0.0,0.0,0.0,0.0)

// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.

#define MOUSE_SPEED vec2(0.5,0.577777) * 0.2
#define MOUSE_POS vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
#define MOUSE_PRESS vec2(1.0,1.0)
#define AUTO_MOUSE vec4( MOUSE_POS, MOUSE_PRESS )



int texture_size = 512;


// Scene Input variables
uniform float cycle_time; 	// Duration of the full cycle
uniform float alpha_on; 	// Time in cycle to switch on alpha channel
uniform float alpha_off; 	// Switch off alpha
uniform float alpha_always_on; 	// Switch off alpha
uniform float scene_length; 	// Switch off alpha

uniform float scene_duration; 


uniform float maxbgnum;	
uniform int file_timestamp; 





vec4 col;
//////////////////////////////////////////////////////////////
// Calgon - Random number

// Extract a pixel from texture1 to get the random number
//float randNum = texture(texture0, vec2(1/10., 1/10.)).r;
//float randNum = texture(texture3, vec2(1/1024., 1/1024.)).a;
float randNum = texture(texture3, vec2(0.,0.)).a;





//float text_line = 3/texture_size;
//float place = 10./texture_size;
//float myCharacter = texture(texture1, vec2(place, text_line)).a;
//int myInt = int(myCharacter*255);

float text_line;
float place;
float myCharacter;
int myInt;



// Extract game data
int game_texture_size = 10;


///////////////////////////////////////////
// Debug
float debug = 0.;



///////////////////////////////////////////////////////////////////////////////////////////////////
// Shadertoy Code follows
// Replace Shadertoy iChannel0..3 with texture0..3
///////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//
// "fontastic" 
//
// small font utility package
//
// by Val "valalalalala" GvM - 2020
// Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License
//
// super useful: https://www.shadertoy.com/view/ldSBzd
// ascii table https://theasciicode.com.ar/
// https://shadertoyunofficial.wordpress.com/2016/07/20/special-shadertoy-features/
//
/////////////////////////////////////////////////////////////////////////////

#define FONT_DEMO

//#define FONT_SAMPLER    texture0
#define FONT_SAMPLER    texture3


#define FONT_STRIDE(n)  ((n)*vec2( .5, .0 ))

#define FONT_STAR 28
#define FONT_0    48
#define FONT_DASH 45
#define FONT_DOT  46
#define FONT_T    84
#define FONT_e    101
#define FONT_s    115
#define FONT_t    116

float characterDistance( vec2 point, int character ) {
    vec2 charAt = vec2( character % 16, 15 - character / 16 ) / 16. + 1./32.;    
    float w = textureLod( FONT_SAMPLER, charAt + point / 16., .0 ).w;
    vec2 box = abs( point / .8 );
    return max( w, max( box.x, box.y ) );
}

float characterLength( int value ) {
    return floor( 1. + log2( float( abs( ( value == 0 ) ? 1 : value ) ) ) / log2( 10.) );
}

float numericStringDistance( vec2 point, int value ) {
    point -= FONT_STRIDE( characterLength( value ) - 1. );
    float d = 0 == value ? characterDistance( point, FONT_0 ) : 1e33;  
    for( int v = abs( value ) ; 0 != v ; v /= 10, point += FONT_STRIDE( 1. ) ) {
        d = min( d, characterDistance( point, FONT_0 + v % 10 ) );
    }  
    return min( d, value < 0 ? characterDistance( point, FONT_DASH ) : 1e33 );
}

float numericStringDistance( in vec2 point, in float value, int decimals ) {
    int vi = int( sign( value ) * floor( abs( value ) ) );
    float d = numericStringDistance( point, vi );  
    
    point -= FONT_STRIDE( characterLength( vi ) );
  //  d = min( d, characterDistance( point, FONT_DOT ) );

    point -= FONT_STRIDE(1.);
    
    float vf = fract( abs( value ) ) * 10.;
    int max = int( pow( 10., float( decimals ) ) );
    for ( int i = 1 ; i <= decimals ; i++, vf *=10. , point -= FONT_STRIDE( 1. ) ) {
        int n = int( vf ) % 10;
        d = min( d, characterDistance( point, FONT_0 + n % 10 ) );
    }

    return d;
}

float numericStringDistance( in vec2 point, in float value ) {
//	return numericStringDistance( point, value, 2 );
    return numericStringDistance( point, value, 0 );
}

float stringDistance( vec2 point, int string ) {
    return 
        min( characterDistance( point, ( string >> 0 ) & 0xFF ),
        min( characterDistance( point - FONT_STRIDE( 1. ), ( string >> 8 ) & 0xFF ),
        min( characterDistance( point - FONT_STRIDE( 2. ), ( string >> 16 ) & 0xFF ),
             characterDistance( point - FONT_STRIDE( 3. ), ( string >> 24 ) & 0xFF ))));
}

float stringDistance( vec2 point, ivec4 string ) {
    return
        min( stringDistance( point - FONT_STRIDE( 0. * 4. ), string[ 0 ] ),
        min( stringDistance( point - FONT_STRIDE( 1. * 4. ), string[ 1 ] ),
        min( stringDistance( point - FONT_STRIDE( 2. * 4. ), string[ 2 ] ),
             stringDistance( point - FONT_STRIDE( 3. * 4. ), string[ 3 ]))));
}

#ifdef FONT_DEMO

#define NUMERIC    numericStringDistance
#define STRING     stringDistance
#define CHARACTER  characterDistance

float distanceToShape( float d, float t ) {
    return smoothstep( .5 - t, .5 + t, 1.-d );
}

void mainImage( out vec4 fragColor, in vec2 fragCoord ) {
    vec2 uv = ( 2. * fragCoord - iResolution.xy ) / iResolution.y;
    
	
	
	
//	float randNum = texture(texture0, vec2(0.,0.)).a;
	float mypath = int(randNum * 100);
	float seed = int(randNum * 256);
	float seed_p = int(randNum * 10000);
	
	
	
//	float mypath = 88.;
	

	
	
	
	
	
	
    float d = 1e33;
	


//	d = min( d, NUMERIC( ( uv - vec2( -1.46, .87 ) ) / .07, mypath ) );




	float fps = 1/iTime;
	
    
    int character = int( mod( iTime, 256. ) );
    vec2 trig = vec2( cos( iTime ), sin( iTime ) );
	vec2 gD = vec2 (0.0);
	gD.x = 1.5/10.;
	gD.y = 1.5/10.;
	
 
	float game1 = texture(texture3, vec2(gD.x,gD.y)).r;
	game1 *= 100;
 
 // Game Data
//	d = min( d, NUMERIC( ( uv - vec2( -1.46, .6 ) ) / .07, game1 ) );
 
	
	float pathway = int(randNum * 100);
//	d = min( d, NUMERIC( ( uv - vec2( -1.46, .87 ) ) / .07, pathway ) );
	
	
	
	float next_girl = scene_length - (scene_length*fract(u_Elapsed/scene_length));
//	d = min( d, NUMERIC( ( uv - vec2( -1.46, .63 ) ) / .07, next_girl ) );
	
	
	
	
	
	float score = int(u_Elapsed/1.)*10.;
	//if (score > 100.){
			

	//}
	
	// Cycles and random stuff..
	// Add the scene number
	float my_cycle_time = maxbgnum * scene_duration;
	float my_part_cycle = my_cycle_time * fract(u_Elapsed / my_cycle_time);
	float cycle_number = floor(u_Elapsed / my_cycle_time) + 1.;
	
	float last_cycle_number = floor((u_Elapsed-scene_duration) / my_cycle_time) + 1.;
	float next_cycle_number = floor((u_Elapsed+scene_duration) / my_cycle_time) + 1.;
	
	
	
	
	
	
	
		// Add in the random start point
	//float start_scene_num = int(randNum * maxbgnum) ;
	float start_scene_num = floor(randNum * maxbgnum) + 1.;
	
	float seed_base = 200 * (start_scene_num - 1.);
	float seed_2 = (seed_p - seed_base)/2.;
	
	float seq = floor(seed_2/20.) + 1;
	
	//start_scene_num = int(start_scene_num) + 1.;
	float show_duration = maxbgnum * scene_duration;
	
	float show_start_scene_num = start_scene_num * 100.;
	
	
	float scene_num = int((my_part_cycle ) / scene_duration) + 1. ;
	//scene_num = my_part_cycle;
	
	
	float new_scene_num = start_scene_num + scene_num;
	
	
//	float rand32 = floor(randNum * 32) + 1;
	
	

//	int primeNumbers[] = int[](3, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79); // Exclude 2 and 5
	
//	int primeNumbers[] = int[](73, 17, 37, 13, 67, 79, 61, 23, 59, 41, 43, 7, 3, 29, 31, 47, 11, 19, 53, 71);
//	int primeNumbers[] = int[](73, 17, 37, 13, 67, 79, 61, 23, 59, 41, 43, 7, 3, 29, 31, 47, 11, 19, 53, 71, 89, 97, 83, 101, 109, 103, 107, 113, 127, 131, 137);
//	int primeNumbers[] = int[](31, 59, 3, 73, 13, 41, 11, 23, 67, 7, 37, 19, 43, 17, 79, 47, 29, 61, 2, 53, 89, 97, 5, 83, 101, 71, 103, 109, 107, 73, 37, 89, 83);


	// 298 Primes - should be plenty
	
	int primeNumbers[] = int[](
    2, 3, 4, 5, 6, 7, 11, 13, 17, 19, 23, 29, 31, 37,
    41, 43, 53, 59, 61, 67, 71, 73, 79,
    83, 89, 97, 101, 103, 107, 109, 113, 127, 131,
    137, 139, 149, 151, 157, 163, 167, 173, 179, 181,
    191, 193, 197, 199, 211, 223, 227, 229, 233, 239,
    241, 251, 257, 263, 269, 271, 277, 281, 283, 293,
    307, 311, 313, 317, 331, 337, 347, 349, 353, 359,
    367, 373, 379, 383, 389, 397, 401, 409, 419, 421,
    431, 433, 439, 443, 449, 457, 461, 463, 467, 479,
    487, 491, 499, 503, 509, 521, 523, 541, 547, 557,
    563, 569, 571, 577, 587, 593, 599, 601, 607, 613,
    617, 619, 631, 641, 643, 647, 653, 659, 661, 673,
    677, 683, 691, 701, 709, 719, 727, 733, 739, 743,
    751, 757, 761, 769, 773, 787, 797, 809, 811, 821,
    823, 827, 829, 839, 853, 857, 859, 863, 877, 881,
    883, 887, 907, 911, 919, 929, 937, 941, 947, 953,
    967, 971, 977, 983, 991, 997, 1009, 1013, 1019, 1021,
    1031, 1033, 1039, 1049, 1051, 1061, 1063, 1069, 1087, 1091,
    1093, 1097, 1103, 1109, 1117, 1123, 1129, 1151, 1153, 1163,
    1171, 1181, 1187, 1193, 1201, 1213, 1217, 1223, 1229, 1231,
    1237, 1249, 1259, 1277, 1279, 1283, 1289, 1297, 1301, 1303,
    1307, 1319, 1321, 1327, 1361, 1367, 1373, 1381, 1399, 1409,
    1423, 1427, 1429, 1433, 1439, 1447, 1451, 1453, 1459, 1471,
    1481, 1483, 1487, 1489, 1493, 1499, 1511, 1529, 1531, 1543,
    1549, 1553, 1559, 1567, 1571, 1579, 1583, 1597, 1601, 1607,
    1609, 1613, 1619, 1621, 1627, 1637, 1657, 1663, 1667, 1669,
    1693, 1697, 1699, 1709, 1721, 1723, 1733, 1741, 1747, 1753,
    1759, 1777, 1783, 1787, 1789, 1801, 1811, 1823, 1831, 1847,
    1861, 1867, 1871, 1873, 1877, 1879, 1889, 1901, 1907, 1913,
    1931, 1933, 1949, 1951, 1973, 1979, 1987, 1993
);


	
	
	
	
	
	
	float first_spacing =   primeNumbers[int(seq * 6.) - 4];
	float two_spacing = 	primeNumbers[int(seq * 6.) - 3];
	float three_spacing = 	primeNumbers[int(seq * 6.) - 2];
	float four_spacing = 	primeNumbers[int(seq * 6.) - 1];


	float rand32 = floor(randNum * 256) + 1;
	int interval = primeNumbers[int(rand32 - 1 +cycle_number -1)];
	int last_interval = primeNumbers[int(rand32 - 1 +last_cycle_number -1)];
	int next_interval = primeNumbers[int(rand32 - 1 +next_cycle_number -1)];
	
	float rand256 = floor(randNum * 256) + 1;
//	int interval = primeNumbers[int(rand32) - 1];
	
	float rand_start = floor(randNum * maxbgnum) + 1;
	
	
	

	float product = scene_num * interval;
//	float actual = floor(maxbgnum* fract(scene_num * interval/maxbgnum) + 0.1);
	
//	float last = floor(maxbgnum* fract((scene_num - 1.) * last_interval/maxbgnum) + 0.1);
//	float next = floor(maxbgnum* fract((scene_num + 1.) * next_interval/maxbgnum) + 0.1);


	float actual = floor(maxbgnum* fract((rand_start + scene_num * interval)/maxbgnum) + 0.1) ;	// Add .1 so we always knock down to whole integer
	float last = floor(maxbgnum* fract((rand_start+(scene_num - 1.) * last_interval)/maxbgnum) + 0.1);
	float next = floor(maxbgnum* fract((rand_start+(scene_num + 1.) * next_interval)/maxbgnum) + 0.1);

	float actual_source = product + rand_start;
	float actual_whole = int(actual_source / maxbgnum);
	
	
	
	
	
	if (actual == 0){
		actual = maxbgnum;
	}

	
	if (next == 0){
		next = maxbgnum;
	}
	
	
	
	
	
	


	
	// Debug Data
	
	
	// https://luckybit4755.github.io/shady-lady/html/text-to-ivec4.html
	if (debug == 1){
		float field_x = -1.76;
		float data_x = -1.32;
		
			
		ivec4 text16 = ivec4( 1818458435, 538983013, 538976288, 538976288 ); /* "Cycle:          " */
		d = min( d, STRING( ( uv - vec2( field_x, .66 ) ) / .06, text16 ) );
		d = min( d, NUMERIC( ( uv - vec2( data_x, .66 ) ) / .06, cycle_number) );
		
		
		ivec4 text5 = ivec4( 1852138323, 540701541, 538976288, 538976288 ); /* "Scenes:         " */
		d = min( d, STRING( ( uv - vec2( field_x, .58 ) ) / .06, text5 ) );
		d = min( d, NUMERIC( ( uv - vec2( data_x, .58 ) ) / .06, maxbgnum) );

		ivec4 text4 = ivec4( 1634891076, 1852795252, 538976314, 538976288 ); /* "Duration:       " */
		d = min( d, STRING( ( uv - vec2( field_x, .54 ) ) / .06, text4 ) );
		d = min( d, NUMERIC( ( uv - vec2( data_x, .54 ) ) / .06, scene_duration) );
		
		
		ivec4 text3 = ivec4( 1684366675, 538976314, 538976288, 538976288 ); /* "Seed:           " */
		d = min( d, STRING( ( uv - vec2( field_x, .50 ) ) / .06, text3 ) );
		d = min( d, NUMERIC( ( uv - vec2( data_x, .50 ) ) / .06, seed ) );
		
		
		ivec4 text12 = ivec4( 1702129225, 1818326642, 538976314, 538976288 ); /* "Interval:       " */
		d = min( d, STRING( ( uv - vec2( field_x, .42 ) ) / .06, text12 ) );
		d = min( d, NUMERIC( ( uv - vec2( data_x, .42 ) ) / .06, interval) );		
		
		ivec4 text1 = ivec4( 1853189955, 538983028, 538976288, 538976288 ); /* "Count:          " */
		d = min( d, STRING( ( uv - vec2( field_x, .38 ) ) / .06, text1 ) );
		d = min( d, NUMERIC( ( uv - vec2( data_x, .38 ) ) / .06, scene_num ) );

		ivec4 text13 = ivec4( 1685025360, 980706165, 538976288, 538976288 ); /* "Product:        " */
		d = min( d, STRING( ( uv - vec2( field_x, .34 ) ) / .06, text13 ) );
		d = min( d, NUMERIC( ( uv - vec2( data_x, .34 ) ) / .06, product) );
		
		ivec4 text14 = ivec4( 2003789907, 979857001, 538976288, 538976288 ); /* "Showing:        " */
		d = min( d, STRING( ( uv - vec2( field_x, .26 ) ) / .06, text14 ) );
		d = min( d, NUMERIC( ( uv - vec2( data_x, .26 ) ) / .06, actual) );
	
		ivec4 text17 = ivec4( 1954047310, 980440352, 538976288, 538976288 ); /* "Next Up:        " */
		d = min( d, STRING( ( uv - vec2( field_x, .22 ) ) / .06, text17 ) );
		d = min( d, NUMERIC( ( uv - vec2( data_x, .22 ) ) / .06, next) );
		
		ivec4 text18 = ivec4( 1684955474, 1635013408, 540701810, 538976288 ); /* "Rand Start:     " */
		d = min( d, STRING( ( uv - vec2( field_x, .12 ) ) / .06, text18 ) );
		d = min( d, NUMERIC( ( uv - vec2( data_x, .12 ) ) / .06, rand_start) );
		
		ivec4 text19 = ivec4( 1970561857, 1394633825, 1668445551, 538983013 ); /* "Actual Source:  " */
		d = min( d, STRING( ( uv - vec2( field_x, .08 ) ) / .06, text19 ) );
		d = min( d, NUMERIC( ( uv - vec2( data_x, .08 ) ) / .06, actual_source) );
		
		ivec4 text20 = ivec4( 1970561857, 1461742689, 1701605224, 538976314 ); /* "Actual Whole:   " */
		d = min( d, STRING( ( uv - vec2( field_x, .04 ) ) / .06, text20 ) );
		d = min( d, NUMERIC( ( uv - vec2( data_x, .04 ) ) / .06, actual_whole) );
		
		
		
		
		
		
		
//		ivec4 text6 = ivec4( 1918989395, 538983028, 538976288, 538976288 ); /* "Start:          " */
//		d = min( d, STRING( ( uv - vec2( field_x, .54 ) ) / .06, text6 ) );
//		d = min( d, NUMERIC( ( uv - vec2( data_x, .54 ) ) / .06, start_scene_num) );
		
		
//		ivec4 text7 = ivec4( 1684366675, 1935761952, 538983013, 538976288 ); /* "Seed base:      " */
//		d = min( d, STRING( ( uv - vec2( field_x, .50 ) ) / .06, text7 ) );
//		d = min( d, NUMERIC( ( uv - vec2( data_x, .50 ) ) / .06, seed_base) );
		
//		ivec4 text8 = ivec4( 1684366675, 540684832, 538976288, 538976288 ); /* "Seed 2:         " */
//		d = min( d, STRING( ( uv - vec2( field_x, .46 ) ) / .06, text8 ) );
//		d = min( d, NUMERIC( ( uv - vec2( data_x, .46 ) ) / .06, seed_2) );
		
//		ivec4 text9 = ivec4( 980510035, 538976288, 538976288, 538976288 ); /* "Seq:            " */
//		d = min( d, STRING( ( uv - vec2( field_x, .42 ) ) / .06, text9 ) );
//		d = min( d, NUMERIC( ( uv - vec2( data_x, .42 ) ) / .06, seq) );
		
//		ivec4 text10 = ivec4( 544502577, 1667330131, 538983013, 538976288 ); /* "1st Space:      " */
//		d = min( d, STRING( ( uv - vec2( field_x, .38 ) ) / .06, text10 ) );
//		d = min( d, NUMERIC( ( uv - vec2( data_x, .38 ) ) / .06, first_spacing) );
//		d = min( d, NUMERIC( ( uv - vec2( data_x + .08, .38 ) ) / .06, two_spacing) );
//		d = min( d, NUMERIC( ( uv - vec2( data_x + .16, .38 ) ) / .06, three_spacing) );
//		d = min( d, NUMERIC( ( uv - vec2( data_x + .24, .38 ) ) / .06, four_spacing) );
		
//		ivec4 text11 = ivec4( 1684955506, 538980915, 538976288, 538976288 ); /* "rand32          " */
//		d = min( d, STRING( ( uv - vec2( field_x, .34 ) ) / .06, text11 ) );
//		d = min( d, NUMERIC( ( uv - vec2( data_x, .34 ) ) / .06, rand32) );
		

	}
	
// Screen Bottom - Scene Number and Filestamp	
	d = min( d, NUMERIC( ( uv - vec2( -1.76, -.94 ) ) / .06, actual ) );
	d = min( d, NUMERIC( ( uv - vec2( -1.76, -.98 ) ) / .032, file_timestamp ) );
	
	float chars_per_line = 30.;
	
	
	
	
	///////// Work out which texture to read
	float bump_time = 0.;
	if (alpha_always_on == 1.){
		bump_time = 1.;
	
	}
	float cycles = (u_Elapsed + bump_time)/cycle_time;
	float full_cycles = trunc(cycles);
    float part_cycles = u_Elapsed - (full_cycles * cycle_time);
	
	float part_even_cycles = fract(full_cycles/2.);
	float even_cycles = 0.;
	if (part_even_cycles > 0.1){
		even_cycles = 1.;
	}
	
	
	
	
	
	
	
	
	
	
	
	
	// Get the length of the message - Add .5 to the distances
	place = (0+.5)/texture_size;
	text_line =  (0.+.5)/texture_size;
	
	if (even_cycles == 0.){
		myCharacter = texture(texture1, vec2(place, text_line)).a;
	}
	else{
		myCharacter = texture(texture2, vec2(place, text_line)).a;
	}
	
	
	//myCharacter = texture(texture1, vec2(place, text_line)).a;
	float msgLen = int(round(myCharacter*255));
	
	for (float x=0; x<=msgLen-1; x++){
		//place = x/512.+.0001;
		place = (.5+x)/texture_size;
		
		text_line =  (1.+.5)/texture_size;
		
		if (even_cycles == 0.){
			myCharacter = texture(texture1, vec2(place, text_line)).a;
		}
		else{
			myCharacter = texture(texture2, vec2(place, text_line)).a;
		}
			
			
			
			
		myInt = int(round(myCharacter*255));
		float x_pos = x/27.-1.75;
		float y_offset = int(x/chars_per_line);
		float y_pos = -y_offset*.1 + .71;
		float adj_x_pos = x_pos - (y_offset)*.1*(chars_per_line);
		//adj_x_pos = x_pos;
		
	//	d = min( d, CHARACTER( ( uv - vec2( adj_x_pos, y_pos ) ) / .07, myInt ) );
		

		
		
		
	}
	
    
	// Notes.... look into how this works further...
	
    // pack 4 characters into an int 
    int test = FONT_T << 0 | FONT_e << 8 | FONT_s << 16 | FONT_t << 24;
 //   d = min( d, STRING(  ( uv - vec2( 1.2, -.4 ) ) / .1, test ) );
 //   d = min( d, NUMERIC( ( uv - vec2( 1.2, -.5 ) ) / .1, test ) );
 //   d = min( d, NUMERIC( ( uv - vec2( 1.2, -.6 ) ) / .1, -1*test ) );
 //   d = min( d, NUMERIC( ( uv - vec2( 1.2, -.7 ) ) / .1, 0*test ) );
	
	
	
	float line_x = 1;
	float line_y = 1;
	
	for (float line_x = 1; line_x <= 30; line_x++)
	{	
		text_line =  4/texture_size;
		float write_x = line_x/20.-0.;
		float letter_img_x = line_x/texture_size;
		
		float myLetter = texture(texture1, vec2(letter_img_x, text_line)).a;
		int myInt = int(myCharacter*255);

		
		
		
		//d = min( d, CHARACTER( ( uv - vec2( write_x, -1. ) ) / .1, myInt ) );
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	

    // https://luckybit4755.github.io/shady-lady/html/text-to-ivec4.html
 //   ivec4 text1 = ivec4( 543516756, 1667855729, 1919033451, 544110447 ); /* "The quick brown " */
 //   ivec4 text2 = ivec4( 544763750, 1886221674, 1986994291, 538997349 ); /* "fox jumps over  " */
  //  ivec4 text3 = ivec4( 543516788, 2038063468, 1735353376, 538976288 ); /* "the lazy dog    " */

	
	ivec4 text1 = ivec4( 1953720644, 1952672114, 538976314, 538976288 ); /* "District:       " */
	ivec4 text2 = ivec4( 1752457552, 981033335, 538976288, 538976288 ); /* "Pathway:        " */
//	ivec4 text3 = ivec4( 1919902547, 538983013, 538976288, 538976288 ); /* "Score:          " */	
	ivec4 text4 = ivec4( 1954047310, 1819692064, 538976314, 538976288 ); /* "Next Lvl:       " */
	

// Removed 12/7/23
	ivec4 text3 = ivec4( 1852138323, 538983013, 538976288, 538976288 ); /* "Scene:          " */
	
 
//    d = min( d, STRING( ( uv - vec2( -1.75, .95 ) ) / .06, text3 ) );
   




  //  d = min( d, CHARACTER( ( uv - vec2( trig.x * 1.33, -.88 ) ) / .22, FONT_STAR ) );

    ////
    
    float r = distanceToShape( d, .00001 );
    float c = distanceToShape( d, .001 );
	
	vec4 finalCol = vec4( vec3( r * 5., c*5., c *.6 ), .5 );
	float grey = (finalCol.r + finalCol.g +finalCol.b);
	finalCol.a = smoothstep(0.,0.01,grey);
	
	
	if (grey > 0.2){
//		finalCol.a = 0.4;
	//	finalCol.r = 0.;
	}
	
	
	//finalCol.r = 0.;
	finalCol.a *= 0.6;
	
	if (part_cycles < alpha_on){
		finalCol.a = 0.0;
	}
	if (part_cycles > alpha_off){
		finalCol.a = 0.0;
	}
	
	vec4 endResult = vec4( vec3( r * 5., c*5., c *.6 ), finalCol.a );
	endResult.rgb = vec3(1.);
	
	// endResult.r = 0.;
	
	
//	endResult.rb = vec2(.7);
	//endResult.a = endResult.g;
	
    //fragColor = vec4( vec3( r * 5., c*5., c *.6 ), finalCol.a );
	fragColor = endResult;
}

#endif
///////////////////////////////////////////////////////////////////////
void main ( void )
{




   mainImage ( gl_FragColor, gl_FragCoord.xy );
   float grey = gl_FragColor.r + gl_FragColor.g + gl_FragColor.b;
   
   if (grey > 0.5){
//	gl_FragColor.a = 0.5;   
   }
   
	if (debug == 1){
		gl_FragColor.a = gl_FragColor.a / 2.;
	
	}
  
   
   
   
   
   // gl_FragColor.a = 1.0;
}












